/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWDesignerPropertyPane;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VWPropertyActionMenu
extends JPopupMenu
implements ActionListener {
    private static final int GROUP_SIZE = 45;
    private JMenu m_stepsMenu = null;
    private JMenu m_routesMenu = null;
    private JMenu m_textAnnotationsMenu = null;
    private JMenu m_associationsMenu = null;
    private JMenuItem m_closeTabsMenuItem = null;
    private JMenuItem m_preferencesMenuItem = null;
    private VWDesignerPropertyPane m_propertyPanel = null;
    private VWMapDefinition m_currentMapDef = null;

    public VWPropertyActionMenu(VWDesignerPropertyPane propertyPanel) {
        this.m_propertyPanel = propertyPanel;
    }

    public void setMap(String mapName) {
        try {
            this.removeAll();
            this.m_currentMapDef = null;
            VWAuthPropertyData propertyData = this.m_propertyPanel.getAuthPropertyData();
            if (propertyData != null) {
                this.m_currentMapDef = mapName == null ? propertyData.getMapDefinition("Workflow") : propertyData.getMapDefinition(mapName);
                if (this.m_currentMapDef != null) {
                    Object[] vwMapNodes = this.m_currentMapDef.getSteps();
                    this.m_stepsMenu = VWStringUtils.getMenuUsingString(VWResource.s_steps_withHK);
                    this.addItemsToMenu(this.m_stepsMenu, vwMapNodes, VWResource.s_processSubMenu);
                    this.add(this.m_stepsMenu);
                    this.m_routesMenu = VWStringUtils.getMenuUsingString(VWResource.s_routes_withHK);
                    if (vwMapNodes != null) {
                        Vector<VWRouteDefinition> routeDefList = new Vector<VWRouteDefinition>();
                        for (int i = 0; i < vwMapNodes.length; ++i) {
                            Object mapNode = vwMapNodes[i];
                            VWRouteDefinition[] vwRouteDefs = ((VWMapNode)mapNode).getNextRoutes();
                            if (vwRouteDefs == null) continue;
                            for (int nRouteIndex = 0; nRouteIndex < vwRouteDefs.length; ++nRouteIndex) {
                                routeDefList.addElement(vwRouteDefs[nRouteIndex]);
                            }
                        }
                        if (routeDefList.size() > 0) {
                            Object[] vwRouteDefs = new VWRouteDefinition[routeDefList.size()];
                            routeDefList.copyInto(vwRouteDefs);
                            this.addItemsToMenu(this.m_routesMenu, vwRouteDefs, VWResource.s_processSubMenu);
                        }
                    }
                    this.add(this.m_routesMenu);
                    Object[] textAnnoDefs = this.m_currentMapDef.getTextAnnotations();
                    this.m_textAnnotationsMenu = VWStringUtils.getMenuUsingString(VWResource.s_textAnnotations_withHK);
                    this.addItemsToMenu(this.m_textAnnotationsMenu, textAnnoDefs, VWResource.s_processSubMenu);
                    this.add(this.m_textAnnotationsMenu);
                    this.m_associationsMenu = VWStringUtils.getMenuUsingString(VWResource.s_associations_withHK);
                    if (textAnnoDefs != null) {
                        Vector<VWAssociationDefinition> associationDefList = new Vector<VWAssociationDefinition>();
                        for (int i = 0; i < textAnnoDefs.length; ++i) {
                            Object textAnnoDef = textAnnoDefs[i];
                            VWAssociationDefinition[] associationDefs = ((VWTextAnnotationDefinition)textAnnoDef).getAllAssociations();
                            if (associationDefs == null) continue;
                            for (int nAssocIndex = 0; nAssocIndex < associationDefs.length; ++nAssocIndex) {
                                associationDefList.addElement(associationDefs[nAssocIndex]);
                            }
                        }
                        if (associationDefList.size() > 0) {
                            Object[] associationDefs = new VWAssociationDefinition[associationDefList.size()];
                            associationDefList.copyInto(associationDefs);
                            this.addItemsToMenu(this.m_associationsMenu, associationDefs, VWResource.s_processSubMenu);
                        }
                    }
                    this.add(this.m_associationsMenu);
                }
            }
            this.add(new JPopupMenu.Separator());
            this.m_closeTabsMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_closeAllTabs_withHK);
            this.m_closeTabsMenuItem.addActionListener(this);
            this.add(this.m_closeTabsMenuItem);
            this.add(new JPopupMenu.Separator());
            this.m_preferencesMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_tabPreferences_withHK);
            this.m_preferencesMenuItem.addActionListener(this);
            this.add(this.m_preferencesMenuItem);
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(o);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_closeTabsMenuItem)) {
                this.m_propertyPanel.closeAllTabs();
            } else if (source.equals(this.m_preferencesMenuItem)) {
                VWAuthPropertyData authPropertyData = this.m_propertyPanel.getAuthPropertyData();
                if (authPropertyData != null) {
                    Integer eventParam = 0;
                    authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 738, eventParam);
                }
            } else if (source instanceof VWPropertyMenuItem) {
                VWPropertyMenuItem menuItem = (VWPropertyMenuItem)source;
                this.m_propertyPanel.displayProperties(menuItem);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addItemsToMenu(JMenu parentMenu, Object[] itemArray, VWString subMenuName) {
        try {
            int nCount = 0;
            int nSubMenuIndex = 1;
            JMenu subMenu = parentMenu;
            if (itemArray != null) {
                int nIndex;
                Object[] menuItems = new VWPropertyMenuItem[itemArray.length];
                VWSessionInfo sessionInfo = this.m_propertyPanel.getAuthPropertyData().getSessionInfo();
                for (nIndex = 0; nIndex < itemArray.length; ++nIndex) {
                    Icon icon = null;
                    if (itemArray[nIndex] instanceof VWMapNode) {
                        icon = VWStepUtils.getStepIcon((VWMapNode)itemArray[nIndex], sessionInfo);
                    }
                    menuItems[nIndex] = new VWPropertyMenuItem(itemArray[nIndex], icon);
                    ((AbstractButton)menuItems[nIndex]).addActionListener(this);
                }
                VWQubbleSort.sort(menuItems);
                if (menuItems.length > 45) {
                    subMenu = new JMenu(subMenuName.toString(Integer.toString(nSubMenuIndex)));
                    this.add(subMenu);
                }
                for (nIndex = 0; nIndex < menuItems.length; ++nIndex) {
                    if (nCount++ > 45) {
                        subMenu = new JMenu(subMenuName.toString(Integer.toString(++nSubMenuIndex)));
                        this.add(subMenu);
                        nCount = 0;
                    }
                    subMenu.add((JMenuItem)menuItems[nIndex]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

